<?php
/* --------------------------------------------------------------
 TokenServiceProvider.php 2020-02-21
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Admin\Application\Token;

use Gambio\Core\Application\ValueObjects\Path;
use Gambio\Core\Application\ServiceProviders\Abstraction\AbstractServiceProvider;

/**
 * Class TokenServiceProvider
 * @package Gambio\Admin\Application\Token
 */
class TokenServiceProvider extends AbstractServiceProvider
{
    /**
     * @inheritDoc
     */
    public function provides(): array
    {
        return [
            TokenService::class
        ];
    }
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->application->share(TokenService::class)->addArgument(SecureTokenRepository::class)->addArgument(
            Path::class
        );
        $this->application->share(SecureTokenRepository::class)->addArgument(Path::class);
    }
}